<?php
/**
 * 2015-2019 Bonpresta
 *
 * Bonpresta Lazy Load Images - Page Speed Optimizer
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the General Public License (GPL 2.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/GPL-2.0
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the module to newer
 * versions in the future.
 *
 *  @author    Bonpresta
 *  @copyright 2015-2019 Bonpresta
 *  @license   http://opensource.org/licenses/GPL-2.0 General Public License (GPL 2.0)
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class Bonlazy extends Module
{
    public function __construct()
    {
        $this->name = 'bonlazy';
        $this->tab = 'front_office_features';
        $this->version = '1.0.0';
        $this->bootstrap = true;
        $this->author = 'Bonpresta';
        $this->module_key = '13165e94a3b4560fffd921559546ebd6';
        parent::__construct();
        $this->default_language = Language::getLanguage(Configuration::get('PS_LANG_DEFAULT'));
        $this->id_shop = Context::getContext()->shop->id;
        $this->displayName = $this->l('Lazy Load Images - Page Speed Optimizer');
        $this->description = $this->l('Lazy load images to improves load speed of page.');
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
        $this->img_dir = __PS_BASE_URI__ . 'modules/bonlazy/views/img/loader.gif';
        if (_PS_VERSION_ >= 1.7) {
            $this->img_array = array(
                array(
                    'img_find' => '<img
                  src = "',
                    'img_replace' => '<img class="lazy" src="' . $this->img_dir . '" data-original="',
                ),
            );
        } else {
            $this->img_array = array(
                array(
                    'img_find' => '<img class="replace-2x img-responsive" src="',
                    'img_replace' => '<img class="lazy" src="' . $this->img_dir . '" data-original="',
                    'script' => '<script type="text/javascript">bonLazy.addTheme();</script>',
                ),
            );
        }
    }

    protected function changeFile($str_1 = 'img_find', $str_2 = 'img_replace', $str_3 = 'script')
    {
        foreach ($this->img_array as $arr) {
            if (_PS_VERSION_ >= 1.7) {
                $file = _PS_ALL_THEMES_DIR_ . _THEME_NAME_ . '/templates/catalog/_partials/miniatures/product.tpl';
            } else {
                $file = _PS_ALL_THEMES_DIR_ . _THEME_NAME_ . '/product-list.tpl';
            }
            $timestamp = time();
            if (copy($file, $file . $timestamp)) {
                $get_content = Tools::file_get_contents($file);
                $res = str_replace($arr[$str_1], $arr[$str_2], $get_content);
                if (_PS_VERSION_ < 1.7) {
                    $res .= $arr['script'];
                }

                $handle = fopen($file, 'w');
                if (flock($handle, LOCK_EX)) {
                    fwrite($handle, $res);
                    flock($handle, LOCK_UN);
                    fclose($handle);
                } else {
                    $this->_errors[] = $this->l('Not open file.');
                    return false;
                }
                if (_PS_VERSION_ < 1.7) {
                    if ($str_3 == '') {
                        $get_content_2 = Tools::file_get_contents($file);
                        $res_2 = str_replace($arr['script'], '', $get_content_2);
                        $handle_2 = fopen($file, 'w');
                        if (flock($handle_2, LOCK_EX)) {
                            fwrite($handle_2, $res_2);
                            flock($handle_2, LOCK_UN);
                            fclose($handle_2);
                        } else {
                            $this->_errors[] = $this->l('Not open file.');
                            return false;
                        }
                    }
                }
            } else {
                $this->_errors[] = $this->l('Check permissions file.');
                return false;
            }
        }
        unset($arr);
    }

    public function install()
    {
        $this->changeFile($str_1 = 'img_find', $str_2 = 'img_replace', $str_3 = 'script');

        return parent::install() &&
            $this->registerHook('displayHeader');
    }

    public function uninstall()
    {
        $this->changeFile($str_1 = 'img_replace', $str_2 = 'img_find', $str_3 = '');
        return parent::uninstall();
    }

    public function getContent()
    {
        $output = '';
        $result = '';

        if ((bool)Tools::isSubmit('submitSettings')) {
            if (!$result = $this->preValidateForm()) {
                $this->processImageUpload($_FILES);
                $output .= $this->displayConfirmation($this->l('Save all settings.'));
            } else {
                $output = $result;
                $output .= $this->renderTabForm();
            }
        }

        if (!$result) {
            $output .= $this->renderTabForm();
        }

        return $output;
    }

    protected function renderTabForm()
    {
        $loader = '';
        $loader .= $this->l('Image for preloading, only .gif') . '<br/><img alt="bonlazy" src="' . $this->img_dir . '" width="100" height="100" /><br />';

        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Settings'),
                    'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'type' => 'file',
                        'label' => $this->l('Add custom loader:'),
                        'name' => 'BONLAZY_ITEM_IMAGE',
                        'desc' => $loader,
                        'display_image' => true,
                    )
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                )
            ),
        );

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitSettings';
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($fields_form));
    }

    public function processImageUpload($FILES)
    {
        if (isset($FILES['BONLAZY_ITEM_IMAGE']) && isset($FILES['BONLAZY_ITEM_IMAGE']['tmp_name']) && !empty($FILES['BONLAZY_ITEM_IMAGE']['tmp_name'])) {
            if (ImageManager::validateUpload($FILES['BONLAZY_ITEM_IMAGE'], 400000)
                || ImageManager::getMimeTypeByExtension($FILES['BONLAZY_ITEM_IMAGE']['name']) != 'image/gif') {
                $this->_errors[] = $this->l('Invalid image type or size. Maximum image width and height equal 300px');
            } else {
                $ext = Tools::substr($FILES['BONLAZY_ITEM_IMAGE']['name'], strrpos($FILES['BONLAZY_ITEM_IMAGE']['name'], '.') + 1);
                $file_name = md5($_FILES['BONLAZY_ITEM_IMAGE']['name']) . '.' . $ext;
                $path = _PS_MODULE_DIR_ . 'bonlazy/views/img/loader.gif';

                if (!move_uploaded_file($FILES['BONLAZY_ITEM_IMAGE']['tmp_name'], $path)) {
                    return $this->_errors[] = $this->l('An error occurred while attempting to upload the file.');
                } else {
                    Configuration::updateValue('BONLAZY_ITEM_IMAGE', $file_name);
                }
            }
        }
    }

    protected function preValidateForm()
    {
        $errors = array();
        $image = Tools::getValue('BONLAZY_ITEM_IMAGE');
        $type = Tools::strtolower(Tools::substr(strrchr($image, '.'), 1));

        if (!empty($image) && $type != 'gif') {
            $errors[] = $this->l('Image format not recognized, allowed format is: .gif');
        }

        if (count($errors)) {
            return $this->displayError(implode('<br />', $errors));
        }

        return false;
    }

    public function hookDisplayHeader()
    {
        $this->context->controller->addCSS($this->_path.'views/css/bonlazy.css');
        if (_PS_VERSION_ >= 1.7) {
            $this->context->controller->addJS($this->_path . '/views/js/lazyload_front.js');
        } else {
            $this->context->controller->addJS($this->_path . '/views/js/lazyload_front_1_6.js');
        }
        $this->context->controller->addJS($this->_path . '/views/js/jquery.lazyload.min.js');
    }
}
