<?php
/**
 * 2015-2018 Bonpresta
 *
 * Bonpresta Add Custom CSS and JavaScript
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the General Public License (GPL 2.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/GPL-2.0
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the module to newer
 * versions in the future.
 *
 *  @author    Bonpresta
 *  @copyright 2015-2018 Bonpresta
 *  @license   http://opensource.org/licenses/GPL-2.0 General Public License (GPL 2.0)
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

include_once(_PS_MODULE_DIR_.'bonjavascript/classes/ClassJavascript.php');

class Bonjavascript extends Module
{
    protected $config_form = false;

    public function __construct()
    {
        $this->name = 'bonjavascript';
        $this->tab = 'front_office_features';
        $this->version = '1.0.1';
        $this->author = 'Bonpresta';
        $this->module_key = '324bdbfe70cdb412a70517532a112282';
        $this->need_instance = 1;
        $this->bootstrap = true;
        parent::__construct();
        $this->default_language = Language::getLanguage(Configuration::get('PS_LANG_DEFAULT'));
        $this->id_shop = Context::getContext()->shop->id;
        $this->displayName = $this->l('Add Custom CSS and JavaScript');
        $this->description = $this->l('Integration custom CSS and JavaScript');
        $this->confirmUninstall = $this->l('This module  Uninstall');
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
    }

    public function createAjaxController()
    {
        $tab = new Tab();
        $tab->active = 1;
        $languages = Language::getLanguages(false);
        if (is_array($languages)) {
            foreach ($languages as $language) {
                $tab->name[$language['id_lang']] = 'bonjavascript';
            }
        }
        $tab->class_name = 'AdminAjaxJavascript';
        $tab->module = $this->name;
        $tab->id_parent = - 1;
        return (bool)$tab->add();
    }

    private function removeAjaxContoller()
    {
        if ($tab_id = (int)Tab::getIdFromClassName('AdminAjaxJavascript')) {
            $tab = new Tab($tab_id);
            $tab->delete();
        }

        return true;
    }

    public function install()
    {
        include(dirname(__FILE__).'/sql/install.php');

        return parent::install() &&
        $this->registerHook('header') &&
        $this->createAjaxController() &&
        $this->registerHook('displayBackOfficeHeader') &&
        $this->registerHook('displayBeforeBodyClosingTag');
    }

    public function uninstall()
    {
        include(dirname(__FILE__).'/sql/uninstall.php');

        return parent::uninstall()
        && $this->removeAjaxContoller();
    }

    public function getContent()
    {

        $output = '';
        $result ='';

        if ((bool)Tools::isSubmit('submitUpdateJavascript')) {
            if (!$result = $this->preValidateForm()) {
                $output .= $this->addJavascript();
            } else {
                $output = $result;
                $output .= $this->renderJavascriptForm();
            }
        }

        if ((bool)Tools::isSubmit('statusbonjavascript')) {
            $output .= $this->updateStatusTab();
        }

        if ((bool)Tools::isSubmit('deletebonjavascript')) {
            $output .= $this->deleteJavascript();
        }

        if (Tools::getIsset('updatebonjavascript') || Tools::getValue('updatebonjavascript')) {
            $output .= $this->renderJavascriptForm();
        } elseif ((bool)Tools::isSubmit('addbonjavascript')) {
            $output .= $this->renderJavascriptForm();
        } elseif (!$result) {
            $output .= $this->renderJavascriptList();
        }

        return $output;
    }

    private function getPage()
    {
        $res = array();
        $controller = Dispatcher::getControllers(_PS_FRONT_CONTROLLER_DIR_);

        if (is_array($controller)) {
            foreach ($controller as $key => $arr) {
                array_push($res, array('id' => $key, 'name' => $key));
            }
            array_unshift($res, array('id' => 'all', 'name' => 'all'));
        }

        return $res;
    }

    protected function renderJavascriptForm()
    {
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => ((int)Tools::getValue('id_tab') ? $this->l('Update module') : $this->l('Add module')),
                    'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->l('Title'),
                        'name' => 'title',
                        'required' => true,
                        'col' => 2
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Page'),
                        'name' => 'page',
                        'options' => array(
                            'query' => $this->getPage(),
                            'id' => 'id',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'textarea',
                        'label' => $this->l('Add css code'),
                        'name' => 'code_css',
                    ),
                    array(
                        'type' => 'textarea',
                        'label' => $this->l('Add javascript code'),
                        'name' => 'code_js',
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Status'),
                        'name' => 'status',
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => $this->l('Disabled')
                            )
                        )
                    ),
                    array(
                        'col' => 2,
                        'type' => 'text',
                        'name' => 'sort_order',
                        'class' => 'hidden'
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                ),
                'buttons' => array(
                    array(
                        'href' => AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
                        'title' => $this->l('Back to list'),
                        'icon' => 'process-icon-back'
                    )
                )
            ),
        );

        if ((bool)Tools::getIsset('updatebonjavascript') && (int)Tools::getValue('id_tab') > 0) {
            $tab = new ClassJavascript((int)Tools::getValue('id_tab'));
            $fields_form['form']['input'][] = array('type' => 'hidden', 'name' => 'id_tab', 'value' => (int)$tab->id);
        }

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitUpdateJavascript';
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigJavascriptFormValues(), /* Add values for your inputs */
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($fields_form));
    }

    protected function getConfigJavascriptFormValues()
    {
        if ((bool)Tools::getIsset('updatebonjavascript') && (int)Tools::getValue('id_tab') > 0) {
            $tab = new ClassJavascript((int)Tools::getValue('id_tab'));
        } else {
            $tab = new ClassJavascript();
        }

        $fields_values = array(
            'id_tab' => Tools::getValue('id_tab'),
            'title' => Tools::getValue('title', $tab->title),
            'code_js' => Tools::getValue('code_js', $tab->code_js),
            'code_css' => Tools::getValue('code_css', $tab->code_css),
            'page' => Tools::getValue('page', $tab->page),
            'status' => Tools::getValue('status', $tab->status),
            'sort_order' => Tools::getValue('sort_order', $tab->sort_order),
        );

        return $fields_values;
    }

    public function renderJavascriptList()
    {
        if (!$tabs = ClassJavascript::getJavascriptList()) {
            $tabs = array();
        }

        $fields_list = array(
            'id_tab' => array(
                'title' => $this->l('Id'),
                'type' => 'text',
                'col' => 6,
                'search' => false,
                'orderby' => false,
            ),
            'title' => array(
                'title' => $this->l('Title'),
                'type' => 'text',
                'search' => false,
                'orderby' => false,
            ),
            'page' => array(
                'title' => $this->l('Page'),
                'type' => 'text',
                'search' => false,
                'orderby' => false,
            ),
            'status' => array(
                'title' => $this->l('Status'),
                'type' => 'bool',
                'active' => 'status',
                'search' => false,
                'orderby' => false,
            ),
            'sort_order' => array(
                'title' => $this->l('Position'),
                'type' => 'text',
                'search' => false,
                'orderby' => false,
                'class' => 'pointer dragHandle'
            )
        );

        $helper = new HelperList();

        $helper->shopLinkType = '';
        $helper->simple_header = false;
        $helper->identifier = 'id_tab';
        $helper->table = 'bonjavascript';
        $helper->actions = array('edit', 'delete');
        $helper->show_toolbar = true;
        $helper->module = $this;
        $helper->title = $this->displayName;
        $helper->listTotal = count($tabs);
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->toolbar_btn['new'] = array(
            'href' => AdminController::$currentIndex
                .'&configure='.$this->name.'&add'.$this->name
                .'&token='.Tools::getAdminTokenLite('AdminModules'),
            'desc' => $this->l('Add new item')
        );
        $helper->currentIndex = AdminController::$currentIndex
            .'&configure='.$this->name.'&id_shop='.(int)$this->context->shop->id;

        $helper->tpl_vars = array(
            'lang_iso' => $this->context->language->iso_code,
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateList($tabs, $fields_list);
    }

    protected function addJavascript()
    {
        $errors = array();

        if ((int)Tools::getValue('id_tab') > 0) {
            $item = new ClassJavascript((int)Tools::getValue('id_tab'));
        } else {
            $item = new ClassJavascript();
        }

        $item->id_shop = (int)$this->context->shop->id;
        $item->status = (int)Tools::getValue('status');
        $item->title = Tools::getValue('title');
        $item->page = Tools::getValue('page');
        $item->code_css = Tools::getValue('code_css');
        $item->code_js = Tools::getValue('code_js');

        if ((int)Tools::getValue('id_tab') > 0) {
            $item->sort_order = Tools::getValue('sort_order');
        } else {
            $item->sort_order = $item->getMaxSortOrder((int)$this->id_shop);
        }

        if (!$errors) {
            if (!Tools::getValue('id_tab')) {
                if (!$item->add()) {
                    return $this->displayError($this->l('The item could not be added.'));
                }
            } elseif (!$item->update()) {
                return $this->displayError($this->l('The item could not be updated.'));
            }

            return $this->displayConfirmation($this->l('The item is saved.'));
        } else {
            return $this->displayError($this->l('Unknown error occurred.'));
        }
    }

    protected function preValidateForm()
    {
        $errors = array();

        if (Tools::isEmpty(Tools::getValue('title'))) {
            $errors[] = $this->l('The title is required.');
        } elseif (!Validate::isGenericName(Tools::getValue('title'))) {
            $errors[] = $this->l('Bad title format.');
        }

        if (count($errors)) {
            return $this->displayError(implode('<br />', $errors));
        }

        return false;
    }

    protected function deleteJavascript()
    {
        $tab = new ClassJavascript(Tools::getValue('id_tab'));
        $res = $tab->delete();

        if (!$res) {
            return $this->displayError($this->l('Error occurred when deleting the tab'));
        }

        return $this->displayConfirmation($this->l('The tab is successfully deleted'));
    }

    protected function updateStatusTab()
    {
        $tab = new ClassJavascript(Tools::getValue('id_tab'));

        if ($tab->status == 1) {
            $tab->status = 0;
        } else {
            $tab->status = 1;
        }

        if (!$tab->update()) {
            return $this->displayError($this->l('The tab status could not be updated.'));
        }

        return $this->displayConfirmation($this->l('The tab status is successfully updated.'));
    }

    public function hookDisplayBackOfficeHeader()
    {
        if (Tools::getValue('configure') != $this->name) {
            return;
        }

        Media::addJsDefL('ajax_theme_url', $this->context->link->getAdminLink('AdminAjaxJavascript'));
        $this->context->smarty->assign('ajax_theme_url', $this->context->link->getAdminLink('AdminAjaxJavascript'));
        $this->context->controller->addJquery();
        $this->context->controller->addJqueryUI('ui.sortable');
        $this->context->controller->addJS($this->_path.'views/js/javascript_back.js');
        $this->context->controller->addCSS($this->_path.'views/css/javascript_back.css');
    }

    public function hookHeader()
    {
        $javascript_front = new ClassJavascript();
        $tabs = $javascript_front->getTopFrontItems($this->id_shop, true);
        $result = array();

        foreach ($tabs as $key => $tab) {
            $result[$key]['page'] = $tab['page'];
            $result[$key]['code_css'] = $tab['code_css'];
            $result[$key]['code_js'] = $tab['code_js'];
        }

        $this->context->smarty->assign('module_page_name', $this->context->controller->php_self);
        $this->context->smarty->assign('items', $result);

        return $this->display($this->_path, '/views/templates/hook/javascript-header.tpl');
    }

    public function hookDisplayBeforeBodyClosingTag()
    {
        $javascript_front = new ClassJavascript();
        $tabs = $javascript_front->getTopFrontItems($this->id_shop, true);
        $result = array();

        foreach ($tabs as $key => $tab) {
            $result[$key]['page'] = $tab['page'];
            $result[$key]['code_css'] = $tab['code_css'];
            $result[$key]['code_js'] = $tab['code_js'];
        }

        $this->context->smarty->assign('module_page_name', $this->context->controller->php_self);
        $this->context->smarty->assign('items', $result);

        return $this->display($this->_path, '/views/templates/hook/javascript-header.tpl');
    }
}
